/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ast.expressions;

import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ExpressionSource;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ast.expressions.Expression;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ast.identifiers.TypeIdentifier;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.FlowValue;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing.InstantiationInfo;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.point.ExpressionContext;
import java.util.List;

public class InstantiationExpression
extends Expression {
    public final TypeIdentifier type;
    public final List<Expression> arguments;

    public InstantiationExpression(ExpressionSource src, TypeIdentifier type, List<Expression> arguments) {
        super(src);
        this.type = type;
        this.arguments = arguments;
    }

    @Override
    public boolean matches(FlowValue node2, ExpressionContext ctx) {
        InstantiationInfo instantiation = (InstantiationInfo)node2.getDecoration("instantiationInfo");
        if (instantiation == null || !this.type.matches(ctx.pool, instantiation.type)) {
            return false;
        }
        return InstantiationExpression.inputsMatch(node2, ctx, ctx.allowIncompleteListInputs, this.arguments.toArray(new Expression[0]));
    }

    @Override
    protected void capture(FlowValue node2, ExpressionContext ctx) {
        if (ctx.type == ExpressionContext.Type.REDIRECT) {
            throw new UnsupportedOperationException("Factory redirects are not supported with expressions! Either switch to @WrapOperation or use the standard NEW injection point.");
        }
        if (ctx.type == ExpressionContext.Type.MODIFY_ARG || ctx.type == ExpressionContext.Type.MODIFY_ARGS) {
            InstantiationInfo instantiation = (InstantiationInfo)node2.getDecoration("instantiationInfo");
            node2 = instantiation.initCall;
        }
        super.capture(node2, ctx);
    }
}

